<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EventRegistration extends Model
{
    protected $fillable = [
        'user_id',
        'event_id',
        'registered_at',
        'attended',
        'amount_paid',
        'transaction_id',
        'payment_status',
    ];

    protected $casts = [
        'registered_at' => 'datetime',
        'attended' => 'boolean',
        'amount_paid' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }
}
