<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SystemSetting extends Model
{
    protected $fillable = [
        'key',
        'value',
        'group',
        'type',
        'label',
        'description',
    ];

    /**
     * Get setting by key
     */
    public static function get($key, $default = null)
    {
        $setting = self::where('key', $key)->first();
        if (!$setting) return $default;

        if ($setting->type === 'boolean') {
            return filter_var($setting->value, FILTER_VALIDATE_BOOLEAN);
        }

        if ($setting->type === 'json') {
            return json_decode($setting->value, true);
        }

        return $setting->value;
    }

    /**
     * Set setting by key
     */
    public static function set($key, $value, $group = 'general', $type = 'text')
    {
        $val = is_array($value) ? json_encode($value) : $value;
        
        return self::updateOrCreate(
            ['key' => $key],
            [
                'value' => $val,
                'group' => $group,
                'type' => $type
            ]
        );
    }
}
